""" test_3.py """
from math import pi
import pyglet
from OpenGL.GL import *
from core.base import Base
from core.opengl_utils import OpenglUtils
from core.attribute import Attribute
from core.uniform import Uniform
from core.matrix import Matrix


class Test(Base):
    """ interactive triangle - global and local translations and rotations """
    def initialise(self):
        print('Initialising program ...')

        vs_code = """
            in vec3 position;
            uniform mat4 projectionMatrix;
            uniform mat4 modelMatrix;
            void main() {
                gl_Position = projectionMatrix * modelMatrix *
                              vec4(position, 1.0);
            }
        """

        fs_code = """
            out vec4 fragColor;
            void main() {
                fragColor = vec4(1.0, 1.0, 0.0, 1.0);
            }
        """

        self.locals['p_ref'] = OpenglUtils.initialise_program(vs_code, fs_code)

        glClearColor(0.0, 0.0, 0.0, 1.0)
        glEnable(GL_DEPTH_TEST)

        vao_ref = glGenVertexArrays(1)
        glBindVertexArray(vao_ref)

        position_data = [[0.0, 0.2, 0.0], [0.1, -0.2, 0.0], [-0.1, -0.2, 0.0]]
        self.locals['vertex_count'] = len(position_data)
        position_attrib = Attribute('vec3', position_data)
        position_attrib.associate_variable(self.locals['p_ref'], 'position')

        model_mat = Matrix.make_translation(0, 0, -1)
        self.locals['model_mat'] = Uniform('mat4', model_mat)
        self.locals['model_mat'].locate_variable(self.locals['p_ref'],
                                                 'modelMatrix')

        proj_mat = Matrix.make_perspective()
        self.locals['proj_mat'] = Uniform('mat4', proj_mat)
        self.locals['proj_mat'].locate_variable(self.locals['p_ref'],
                                                'projectionMatrix')

        self.locals['move_speed'] = 0.5
        self.locals['turn_speed'] = 90.0 / 180.0 * pi

    def update(self, delta):
        move_amt = self.locals['move_speed'] * delta
        turn_amt = self.locals['turn_speed'] * delta

        if self.input.is_key_pressed(pyglet.window.key.W):
            m = Matrix.make_translation(0, move_amt, 0)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data
        if self.input.is_key_pressed(pyglet.window.key.S):
            m = Matrix.make_translation(0, -move_amt, 0)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data
        if self.input.is_key_pressed(pyglet.window.key.A):
            m = Matrix.make_translation(-move_amt, 0, 0)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data
        if self.input.is_key_pressed(pyglet.window.key.D):
            m = Matrix.make_translation(move_amt, 0, 0)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data
        if self.input.is_key_pressed(pyglet.window.key.Z):
            m = Matrix.make_translation(0, 0, move_amt)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data
        if self.input.is_key_pressed(pyglet.window.key.X):
            m = Matrix.make_translation(0, 0, -move_amt)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data

        if self.input.is_key_pressed(pyglet.window.key.Q):
            m = Matrix.make_rotation_z(turn_amt)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data
        if self.input.is_key_pressed(pyglet.window.key.E):
            m = Matrix.make_rotation_z(-turn_amt)
            self.locals['model_mat'].data = m @ self.locals['model_mat'].data

        if self.input.is_key_pressed(pyglet.window.key.I):
            m = Matrix.make_translation(0, move_amt, 0)
            self.locals['model_mat'].data = self.locals['model_mat'].data @ m
        if self.input.is_key_pressed(pyglet.window.key.K):
            m = Matrix.make_translation(0, -move_amt, 0)
            self.locals['model_mat'].data = self.locals['model_mat'].data @ m
        if self.input.is_key_pressed(pyglet.window.key.J):
            m = Matrix.make_translation(-move_amt, 0, 0)
            self.locals['model_mat'].data = self.locals['model_mat'].data @ m
        if self.input.is_key_pressed(pyglet.window.key.L):
            m = Matrix.make_translation(move_amt, 0, 0)
            self.locals['model_mat'].data = self.locals['model_mat'].data @ m

        if self.input.is_key_pressed(pyglet.window.key.U):
            m = Matrix.make_rotation_z(turn_amt)
            self.locals['model_mat'].data = self.locals['model_mat'].data @ m
        if self.input.is_key_pressed(pyglet.window.key.O):
            m = Matrix.make_rotation_z(-turn_amt)
            self.locals['model_mat'].data = self.locals['model_mat'].data @ m

        glUseProgram(self.locals['p_ref'])

    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        self.locals['proj_mat'].upload_data()
        self.locals['model_mat'].upload_data()
        glDrawArrays(GL_TRIANGLES, 0, self.locals['vertex_count'])


Test(caption='test-3.py').run()
