""" test_2_7.py """
from OpenGL.GL import *
from core.base import Base
from core.opengl_utils import OpenglUtils
from core.attribute import Attribute
from core.uniform import Uniform


class Test(Base):
    """ animate triangle """
    def initialise(self):
        print('Initialising program ...')

        vs_code = """
            in vec3 position;
            uniform vec3 translation;
            void main() {
                vec3 pos = position + translation;
                gl_Position = vec4(pos.x, pos.y, pos.z, 1.0);
            }
        """

        fs_code = """
            uniform vec3 baseColor;
            out vec4 fragColor;
            void main() {
                fragColor = vec4(baseColor.r, baseColor.g, baseColor.b, 1.0);
            }
        """

        self.locals['p_ref'] = OpenglUtils.initialise_program(vs_code, fs_code)

        glClearColor(0.0, 0.0, 0.0, 1.0)

        vao_ref = glGenVertexArrays(1)
        glBindVertexArray(vao_ref)

        position_data = [[0.0, 0.2, 0.0], [0.2, -0.2, 0.0], [-0.2, -0.2, 0.0]]
        self.locals['vertex_count'] = len(position_data)

        position_attribute = Attribute('vec3', position_data)
        position_attribute.associate_variable(self.locals['p_ref'], 'position')

        self.locals['t'] = Uniform('vec3', [-0.5, 0.0, 0.0])
        self.locals['t'].locate_variable(self.locals['p_ref'], 'translation')
        self.locals['c'] = Uniform('vec3', [1.0, 0.0, 0.0])
        self.locals['c'].locate_variable(self.locals['p_ref'], 'baseColor')

        glUseProgram(self.locals['p_ref'])

    def update(self, delta):
        self.locals['t'].data[0] += delta * 0.5
        if self.locals['t'].data[0] > 1.2:
            self.locals['t'].data[0] = -1.2

    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT)

        self.locals['t'].upload_data()
        self.locals['c'].upload_data()
        glDrawArrays(GL_TRIANGLES, 0, self.locals['vertex_count'])


Test(caption='test-2-7').run()
