""" test_2_4.py """
from OpenGL.GL import *
from core.base import Base
from core.opengl_utils import OpenglUtils
from core.attribute import Attribute


class Test(Base):
    """ rendering two shapes """
    def initialise(self):
        print('Initialising program ...')

        vs_code = """
            in vec3 position;
            void main() {
                gl_Position = vec4(position.x, position.y, position.z, 1.0);
            }
        """

        fs_code = """
            out vec4 fragColor;
            void main() {
                fragColor = vec4(1.0, 1.0, 0.0, 1.0);
            }
        """

        self.locals['p_ref'] = OpenglUtils.initialise_program(vs_code, fs_code)

        glLineWidth(4)

        self.locals['tri_vao'] = glGenVertexArrays(1)
        glBindVertexArray(self.locals['tri_vao'])
        position_data = [[-0.5, 0.8, 0.0], [-0.2, 0.2, 0.0], [-0.8, 0.2, 0.0]]
        self.locals['tri_count'] = len(position_data)
        position_attribute = Attribute('vec3', position_data)
        position_attribute.associate_variable(self.locals['p_ref'], 'position')

        self.locals['sqr_vao'] = glGenVertexArrays(1)
        glBindVertexArray(self.locals['sqr_vao'])
        position_data = [[0.8, 0.8, 0.0], [0.8, 0.2, 0.0],
                         [0.2, 0.2, 0.0], [0.2, 0.8, 0.0]]
        self.locals['sqr_count'] = len(position_data)
        position_attribute = Attribute('vec3', position_data)
        position_attribute.associate_variable(self.locals['p_ref'], 'position')

        glUseProgram(self.locals['p_ref'])

    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT)

        glBindVertexArray(self.locals['tri_vao'])
        glDrawArrays(GL_LINE_LOOP, 0, self.locals['tri_count'])

        glBindVertexArray(self.locals['sqr_vao'])
        glDrawArrays(GL_LINE_LOOP, 0, self.locals['sqr_count'])


Test(caption='test-2-4').run()
