""" test_2_3.py """
from OpenGL.GL import *
from core.base import Base
from core.opengl_utils import OpenglUtils
from core.attribute import Attribute


class Test(Base):
    """ render shape """
    def initialise(self):
        print('Initialising program ...')

        vs_code = """
            in vec3 position;
            void main(){
                gl_Position = vec4(position.x, position.y, position.z, 1.0);
            }
        """

        fs_code = """
            out vec4 fragColor;
            void main() {
                fragColor = vec4(1.0, 1.0, 0.0, 1.0);
            }
        """

        self.locals['p_ref'] = OpenglUtils.initialise_program(vs_code, fs_code)

        glLineWidth(4)

        vao_ref = glGenVertexArrays(1)
        glBindVertexArray(vao_ref)

        position_data = [[0.8, 0.0, 0.0], [0.4, 0.6, 0.0], [-0.4, 0.6, 0.0],
                         [-0.8, 0.0, 0.0], [-0.4, -0.6, 0.0], [0.4, -0.6, 0.0]]
        self.locals['vertex_count'] = len(position_data)
        position_attribute = Attribute('vec3', position_data)
        position_attribute.associate_variable(self.locals['p_ref'], 'position')
        glUseProgram(self.locals['p_ref'])

    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT)
        glDrawArrays(GL_LINE_LOOP, 0, self.locals['vertex_count'])


Test(caption='test-2-3').run()
