""" test_2_2.py """
from OpenGL.GL import *
from core.base import Base
from core.opengl_utils import OpenglUtils


class Test(Base):
    """ test """
    def initialise(self):
        print('Initialising program ...')

        vs_code = """
            void main() {
                gl_Position = vec4(0.0, 0.0, 0.0, 1.0);
            }
        """

        fs_code = """
            out vec4 fragColor;
            void main() {
                fragColor = vec4(1.0, 1.0, 0.0, 1.0);
            }
        """

        self.locals['p_ref'] = OpenglUtils.initialise_program(vs_code, fs_code)
        vao_ref = glGenVertexArrays(1)
        glBindVertexArray(vao_ref)

        glPointSize(16)

    def update(self, delta):
        glUseProgram(self.locals['p_ref'])

    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT)
        glDrawArrays(GL_POINTS, 0, 1)


Test(screen_size=(720, 720), caption='test-2-2').run()
