""" uniform.py """
from OpenGL.GL import *


class Uniform():
    """ uniform variables """
    def __init__(self, data_type, data):
        self.data_type = data_type
        self.data = data
        self.variable_name = None
        self.variable_ref = None

    def locate_variable(self, p_ref, variable_name):
        """ locate """
        self.variable_name = variable_name
        self.variable_ref = glGetUniformLocation(p_ref, variable_name)

    def upload_data(self):
        """ upload """
        if self.variable_ref == -1:
            return

        match self.data_type:
            case 'int':
                glUniform1i(self.variable_ref, self.data)
            case 'bool':
                glUniform1i(self.variable_ref, self.data)
            case 'float':
                glUniform1f(self.variable_ref, self.data)
            case 'vec2':
                glUniform2f(self.variable_ref, *self.data)
            case 'vec3':
                glUniform3f(self.variable_ref, *self.data)
            case 'vec4':
                glUniform4f(self.variable_ref, *self.data)
            case 'mat4':
                glUniformMatrix4fv(self.variable_ref, 1, GL_TRUE, self.data)
            case _:
                msg = '\nUniform "{}" has unknown type "{}".'
                raise RuntimeError(msg.format(self.variable_name,
                                              self.data_type))
