""" object_3d.py """
from core.matrix import Matrix


class Object3d():
    """ 3d object """
    def __init__(self):
        self.transform = Matrix.make_indentity()
        self.parent = None
        self.children = []

    def add(self, child):
        self.children.append(child)
        child.parent = self

    def remove(self, child):
        self.children.remove(child)
        child.parent = None

    def get_world_matrix(self):
        if self.parent is None:
            return self.transform
        return self.parent.get_world_matrix() @ self.transform

