""" input.py """
import pyglet


class Input():
    """ separate out input handling """
    def __init__(self):
        self.keys_pressed = []
        self.quit = False

    def update_on_key_press(self, symbol, modifiers):
        """ check the key input """
        if modifiers == Input.ctrl and symbol == Input._q_:
            self.quit = True
        else:
            self.keys_pressed.append(symbol)

    def update_on_key_release(self, symbol, modifiers):
        """ check the key input """
        try:
            self.keys_pressed.remove(symbol)
        except ValueError:
            msg = 'W: Attempted to remove key "{}" but not in list.'
            print(msg.format(symbol))

    def is_key_pressed(self, key):
        """ check the key input """
        return key in self.keys_pressed

    ctrl, _q_ = pyglet.window.key.MOD_CTRL, pyglet.window.key.Q
