""" attribute.py """
from OpenGL.GL import *
import numpy


class Attribute():
    """ attribute variables """
    def __init__(self, data_type, data):
        self.data_type = data_type
        self.data = data
        self.buffer_ref = glGenBuffers(1)
        self.upload_data()

    def upload_data(self):
        """ upload """
        data = numpy.array(self.data).astype(numpy.float32)
        glBindBuffer(GL_ARRAY_BUFFER, self.buffer_ref)
        glBufferData(GL_ARRAY_BUFFER, data.ravel(), GL_STATIC_DRAW)

    def associate_variable(self, p_ref, variable_name):
        """ associate """
        variable_ref = glGetAttribLocation(p_ref, variable_name)
        if variable_ref == -1:
            return

        base_type = GL_FLOAT
        match self.data_type:
            case 'int':
                size, base_type = 1, GL_INT
            case 'float':
                size = 1
            case 'vec2':
                size = 2
            case 'vec3':
                size = 3
            case 'vec4':
                size = 4
            case _:
                msg = '\nAttribute "{}" has unknown type "{}".'
                raise RuntimeError(msg.format(variable_name, self.data_type))

        glBindBuffer(GL_ARRAY_BUFFER, self.buffer_ref)
        glVertexAttribPointer(variable_ref, size, base_type, False, 0, None)
        glEnableVertexAttribArray(variable_ref)
